
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using System;
using System.Collections.Generic;
using System.Reflection;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.GamerServices;

//using GE.Gui.Forms;

namespace GE.Tools
{
    /// <summary>
    /// Error Manager.
    /// </summary>
    class Logger
    {
        /// <summary>
        /// Unique instance of the Logger class.
        /// </summary>
        private static Logger m_instance = new Logger();

        /// <summary>
        /// Game instance.
        /// </summary>
        private object m_game;

        /// <summary>
        /// MethodInfo of the Exit method of the game.
        /// </summary>
        private MethodInfo m_exit;

        /// <summary>
        /// Property of m_instance.
        /// </summary>
        public static Logger Instance
        {
            get { return m_instance; }
        }

        /// <summary>
        /// Private Constructor.
        /// </summary>
        private Logger()
        {
        }

        /// <summary>
        /// Initializes the Logger component.
        /// </summary>
        /// <param name="game">game instance</param>
        /// <param name="exit">MethodInfo of the Exit method of the game</param>
        public void init(object game, MethodInfo exit)
        {
            m_game = game;
            m_exit = exit;
        }

        /// <summary>
        /// Sends an error.
        /// </summary>
        /// <param name="emitter">objet mettant l'erreur</param>
        /// <param name="message">message d'erreur</param>
        public void error(object emitter, string message)
        {
            error(emitter, null, message);
        }

        /// <summary>
        /// Sends an error.
        /// </summary>
        /// <param name="emitter">objet mettant l'erreur</param>
        /// <param name="exception">exception ayant provoque l'erreur</param>
        /// <param name="message">message d'erreur</param>
        public void error(object emitter, Exception exception, string message)
        {
#if XBOX
            if (Guide.IsVisible)
                return;
            List<string> buttons = new List<string>();
            buttons.Add("Ok");
            
            Guide.BeginShowMessageBox(PlayerIndex.One, "Error",
                message + "\nFrom : " + emitter.ToString(),
                buttons, 0, MessageBoxIcon.Error, new AsyncCallback(errorCallback), null);
#else
            
#endif
        }

        public void errorCallback(IAsyncResult result)
        {
            Guide.EndShowMessageBox(result);
            exit();
        }

        /// <summary>
        /// Exits the game.
        /// </summary>
        private void exit()
        {
            object[] args = { };
            m_exit.Invoke(m_game, args);
        }
    }
}
